---
generated_at: 2026-02-03 10:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-next test

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし。全主張に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/cli/next-test.ts` - next testコマンドの実装（199行）
- E-02: `packages/next/src/bin/next.ts` - CLIエントリーポイント（495-526行目）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NextTestOptionsはtestRunnerプロパティのみ | E-01 (18-20行目) | ○ |
| C-02 | SUPPORTED_TEST_RUNNERS_LISTは['playwright']のみ | E-01 (22行目) | ○ |
| C-03 | 必要パッケージは@playwright/test | E-01 (28-31行目) | ○ |
| C-04 | directory引数の曖昧性解決ロジック | E-01 (45-67行目) | ○ |
| C-05 | テストランナー優先順位: CLI > config > default | E-01 (70-73行目) | ○ |
| C-06 | testProxy: true が必須 | E-01 (75-79行目) | ○ |
| C-07 | 未サポートランナー時にエラー終了 | E-01 (85-88行目) | ○ |
| C-08 | 依存パッケージ未インストール時に自動インストール | E-01 (100-101行目) | ○ |
| C-09 | playwright installも実行 | E-01 (103-114行目) | ○ |
| C-10 | findUpでplaywright設定ファイルを検索 | E-01 (130-135行目) | ○ |
| C-11 | TypeScript判定後に設定ファイルを自動生成 | E-01 (140-163行目) | ○ |
| C-12 | 設定存在時はplaywright testを実行 | E-01 (170-186行目) | ○ |
| C-13 | コマンド名はexperimental-test | E-02 (496行目) | ○ |
| C-14 | allowUnknownOptionが設定 | E-02 (518行目) | ○ |
| C-15 | defaultPlaywrightConfigはTS/JS両方対応 | E-01 (189-198行目) | ○ |
| C-16 | cross-spawnでplaywrightを実行 | E-01 (16行目, 170行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。

## 5) リスクフラグ（レビュー観点）
- 0: directory引数の曖昧性解決ロジックが複雑なため、エッジケースに注意
- 0: 自動インストール機能は開発者の意図しないパッケージインストールを行う可能性

## 6) レビュアーチェックリスト（最小）
- [ ] directory引数の曖昧性解決ロジックが正確に記述されているか
- [ ] テストランナー優先順位が正しいか
- [ ] 設定ファイル自動生成の内容が正確か
- [ ] experimental-testのコマンド名が正しいか
